﻿/*	VER:		1.1
	1.1		Detects when time has passed between function calls and treats that as a stack-clear  (reset "stackIndex" if time has passed)

USAGE:
	#include "functions/avoidLoopPanic.as"
	_global.AVOID_LOOP_PANIC = make_avoidLoopPanic( 50 );
	
	
	// stres test
	i = 0;
	stress = function(){
		trace(i);
		i++;
		if(i<300){
			AVOID_LOOP_PANIC( stress );
		}// if:  this function has recursed less than 300 times  (exceeds Flash's 256 function stack-limit)
	}// stress()
	stress();
	
DESCRIPTION:	
	This prevents Flash from freezing when a lot of functions are called very quickly, from inside each other, thus filling the function-call stack.
	It does this by intoducing a delay after a certain number of functions has been called, which allows the function-call stack to clear.
	Use this when some processor-intensive functions cause Flash to freeze inexplicably, and Flash's trace output complains about detecting an "infinite loop."
	Only use this with asynchronous functions.
*/
function make_avoidLoopPanic( thresh ){
	var thresh = thresh || 40;
	var stackCounter = 0;
	var delay = 0;
	var timeout = null;
	
	function resetStackCounter(){
		stackCounter = 0;
	}// resetStackCounter()
	
	return function( callback ){
		stackCounter++;
		if(stackCounter > thresh){
			if(timeout!==null)	clearTimeout(timeout);
			setTimeout(function(){
				resetStackCounter();
				callback();
			}, delay);
		}else{
			callback();
			// if any time passes, reset the recursion counter
			if(timeout!==null)	clearTimeout(timeout);
			timeout = setTimeout( function(){
				resetStackCounter();
			}, 0 );
		}
	}// return AVOID_LOOP_PANIC()
}// make_avoidLoopPanic()